﻿using System.Collections.Generic;

using VIRP.EFR.BO;
using VIRP.EFR.DAL;

namespace VIRP.EFR.BLL
{
    public static class PatientManager
    {
        public static IEnumerable<PatientSearchResult> SearchPatients(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            string PATIENT_ICN,
            string PATIENT_SSN,
            string PATIENT_LAST_NAME,
            string PATIENT_FIRST_NAME,
            string SORT_COLUMN,
            int? START_ROW,
            int? MAX_ROWS)
        {
            var db = new PatientDB();

            var results = db.SearchPatients(
                CURRENT_USER,
                CURRENT_REGISTRY_ID,
                PATIENT_ICN,
                PATIENT_SSN,
                PATIENT_LAST_NAME,
                PATIENT_FIRST_NAME,
                SORT_COLUMN,
                START_ROW,
                MAX_ROWS);

            return results;
        }

        public static int SearchPatientsCount(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            string PATIENT_ICN,
            string PATIENT_SSN,
            string PATIENT_LAST_NAME,
            string PATIENT_FIRST_NAME,
            string SORT_COLUMN,
            int? START_ROW,
            int? MAX_ROWS)
        {
            var db = new PatientDB();

            return db.SearchPatientsCount(
                CURRENT_USER,
                CURRENT_REGISTRY_ID,
                PATIENT_ICN,
                PATIENT_SSN,
                PATIENT_LAST_NAME,
                PATIENT_FIRST_NAME);
        }

        public static IEnumerable<PatientSearchResult> SearchAllPatients(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            string PATIENT_ICN,
            string PATIENT_SSN,
            string PATIENT_LAST_NAME,
            string PATIENT_FIRST_NAME,
            string SORT_COLUMN,
            int? START_ROW,
            int? MAX_ROWS)
        {
            var db = new PatientDB();

            var results = db.SearchAllPatients(
                CURRENT_USER,
                CURRENT_REGISTRY_ID,
                PATIENT_ICN,
                PATIENT_SSN,
                PATIENT_LAST_NAME,
                PATIENT_FIRST_NAME,
                SORT_COLUMN,
                START_ROW,
                MAX_ROWS);

            return results;
        }

        public static int SearchAllPatientsCount(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            string PATIENT_ICN,
            string PATIENT_SSN,
            string PATIENT_LAST_NAME,
            string PATIENT_FIRST_NAME,
            string SORT_COLUMN,
            int? START_ROW,
            int? MAX_ROWS)
        {
            var db = new PatientDB();

            return db.SearchAllPatientsCount(
                CURRENT_USER,
                CURRENT_REGISTRY_ID,
                PATIENT_ICN,
                PATIENT_SSN,
                PATIENT_LAST_NAME,
                PATIENT_FIRST_NAME);
        }
    }
}
